﻿// Procedure Loader Hide
#pragma TextEncoding = "UTF-8"
#pragma rtGlobals=3
#pragma IgorVersion = 8
#pragma hide=1

// ***
// HISTOGRAMS

// show/hide histogram tab
// how = 0 show
// how = 1 hide
Function disp_ShowHideHistograms(how)
	variable how

	// fix if histogram window has been deleted
	DoWindow $k_histGraphs
	if (v_flag == 0)
		disp_ShowHistograms(0)
	endif
	SetWindow $k_histGraphs, hide=how
	return 0
end

// update histogram
Function disp_UpdateHistograms()

	variable histgr
	
	histgr = disp_ShowHistograms(1)
	// no histogram graph window
	if (histgr < 0)
		disp_ShowHistograms(0)
	endif
	T3_UpdateContactPrint()
	return 0
end

// generate the histogram
// toRoI - 1 means generate them within a defined RoI
Function generate_Histograms(toRoI)
	variable toRoI
	
	DFREF cdf = GetDataFolderDFR()

	// global values
	DFREF pf = $k_fullpackageFolder
	SVAR/SDFR=pf cwdfolder, cwfile
	
	string dfstr, imgHstr, imgroot, maskWave, sfile
	variable quiet=0, maskordraw, wtype
	variable bflag=0, tflag=0, dhmin, dhmax
	variable isstack=0, stnum, cplane
	variable multiplier = 1	
	
	dfstr = "root:" + cwdfolder
	DFREF wf = $dfstr
	
	imgroot = StringFromList(1,cwfile,"_")
	
	SetDataFolder wf
	
	// do not re-generate histogram for threshold or fill images
	
	sfile = f_DisplayImageID(-1)

	wave wimg = $sfile
	
	// extract only the current stack plane
	if (f_isStack()==1)
		cplane = f_PlaneNumber()
		MatrixOp/O himg = wimg[][][cplane]
		CopyScales wimg, himg
		isstack = 1
	else
		duplicate/O wimg himg
	endif

#ifdef DEBUG
	print "generating histogram for ", cwdfolder, cwfile, cplane
#endif
	
	NewDataFolder/O/S $k_histFolder
	
	// single channel or three channel
	tflag = f_imgRGB(thisimg=himg)
	
	// check whether mq or drawing exists for histogram
	if (toRoI > 0)
		if (!(f_HasMQ() || f_HasHRoI()))
			toRoI = 0
		endif
	endif
	
	// get marquee region
	STRUCT S_MarqueeCoordinates mc
	
	switch(toRoI)
		case 0:	// all image
			break
		default:		
			if (f_HasHRoI()==1)
				Sf_GetHRoICoordinates(mc)
			elseif (f_HasMQ()==1)
				Sf_GetMQCoordinates(mc)
			endif
			break
	endswitch
	
	// generate histogram	
	switch(toRoI)
		case 0:		// histogram over all image
			if (bflag)
				ImageHistogram/I himg
			else
				ImageHistogram himg
			endif
			if (!tflag)
				wave/Z W_imageHist
			else
				wave/Z W_imageHistR, W_imageHistG, W_imageHistB
			endif
			duplicate/O himg ROIMask
			ROIMask = 1
			break
		case 3:		// inside - outside
		case 4:		// outside - inside
			if (tflag)
				break
			endif
			multiplier = toRoI == 3 ? -1 : 1
			// get inside
			wave RoIMask = generate_RoIMask(himg,mc,1,0)
			if (bflag)
				ImageHistogram/I/R=RoIMask himg
			else
				ImageHistogram/R=RoIMask himg
			endif
			wave W_imageHist
			duplicate/FREE W_imageHist iHoutside
			// get inside
			wave RoIMask = generate_RoIMask(himg,mc,2,0)
			if (bflag)
				ImageHistogram/I/R=RoIMask himg
			else
				ImageHistogram/R=RoIMask himg
			endif
			W_imageHist -= iHoutside
			W_imageHist *= multiplier
			W_imageHist = W_imageHist < 0 ? NaN : W_imageHist
			//W_imageHist = abs(W_imageHist)
			break
		// case 1 - outside, 2 - inside
		default:		// histogram with RoI
			if (tflag)
				break
			endif
			// get mask
			wave RoIMask = generate_RoIMask(himg,mc,toRoI,0)
			if (bflag)
				ImageHistogram/I/R=RoIMask himg
			else
				ImageHistogram/R=RoIMask himg
			endif
			wave W_imageHist
			break
	endswitch
	
	switch(tflag)
		case 0:		// single channel image
			wave iHo = W_imageHist
			break
		case 1:		// rgb image
			wave iHRo = W_imageHistR
			wave iHGo = W_imageHistG
			wave iHBo = W_imageHistB
			duplicate/O/FREE iHRo, iHo
			iHo += iHGo + iHBo
			break
	endswitch	
	
	imgHstr = "hist_" + imgroot	
	duplicate/O iHo, $imgHstr
	wave iH = $imgHstr
	// 16 bit rescale to step of 1
	if (bflag==1)
		SetScale/P x 0,1,"", iH
	endif
	
	imgHstr = "chist_" + imgroot
	duplicate/O iH, $imgHstr
	wave iCH = $imgHstr
	integrate/T iCH /D=iCH
	
	imgHstr = "dhist_" + imgroot
	duplicate/O iH, $imgHstr
	wave iDH = $imgHstr
	differentiate iDH /D=iDH
	WaveStats/Q iDH
	dhmax = max(abs(v_max),abs(v_min))
	iDH /= dhmax
	
	// get image statistics
	get_imgStats(himg, ROIMask, toRoI, mc)	
#ifndef DEBUG
	killwaves/Z RoIMask, himg, W_imageHist, W_imageHistR, W_imageHistG, W_imageHistB
#endif	
	SetDataFolder cdf

	return 0
end

// get image statistics
Function get_imgStats(imgwave, ROIMask, toRoI, mc)
	wave imgwave, ROIMask
	variable toRoI
	STRUCT S_MarqueeCoordinates &mc

	NewDataFolder/O/S cimg_istats
	
	variable/G gimin, gimax, giave, gistd, gitotal
	variable/G groimin, groimax, groiave, groistd, groitotal

	// full image
	
	ImageStats imgwave
	gimin = V_min; gimax = V_max
	giave = v_avg; gistd = v_sdev
	gitotal = v_avg*v_npnts
	
	switch(toRoI)
		case 0:	// full image
			groimin = gimin
			groimax = gimax
			groiave = giave
			groistd = gistd
			groitotal = gitotal
			break
		case 1:	// inside RoI
		case 2: 	// outside RoI
			ImageStats/R=ROIMask imgwave
			groimin = V_min; groimax = V_max
			groiave = v_avg; groistd = v_sdev
			groitotal = v_avg*v_npnts
			break
		default:	// stats for all other should be ignored
			groimin = NaN; groimax = NaN
			groiave = NaN; groistd = NaN
			groitotal = NaN
			break
	endswitch
	
	SetDataFolder :
	return 0
end

// scale the derivative of the histogram
Function Scale_DHistogram(sf)
	variable sf
	
	variable dhmin, dhmax
	dhmin = -(10^(-sf))
	dhmax = (10^(-sf))
	SetAxis/W=$k_histgraphs dhist dhmin,dhmax

	return 0	
end
